#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os, sys, site 
import datetime
import urllib
import urlparse
import re
import math
import codecs

from generator import *

from mako.template import Template
from mako.lookup import TemplateLookup

import web

css_path = [PANEO_SITE_DATA_DIR+'common/css/']


import scss
scss.LOAD_PATHS = css_path 

TLOOKUP = TemplateLookup(   directories=css_path,
                            input_encoding='utf-8',
                            output_encoding='utf-8',
                            encoding_errors='replace', 
                            cache_impl='beaker',
                            cache_args={
                            },
                            imports = RENDER_IMPORTS )

from paneo_html import PaneoImage

#from beaker.cache import CacheManager
#from beaker.util import parse_cache_config_options
#
#cache_opts = {
#    'cache.type': 'file',
#    'cache.data_dir': PANEO_SITE_DATA_DIR + '/_tmp/cache/data',
#    'cache.lock_dir': PANEO_SITE_DATA_DIR + '/_tmp/cache/lock'
#}
#cache = CacheManager(**parse_cache_config_options(cache_opts))
#
#@cache.cache(expire=300)

from beaker import cache

cachemg = cache.CacheManager(cache_regions={
'default' :{
        'type':'memcached',
        'url':'127.0.0.1:11211',
        'expiretime':1,
        'lock_dir': PANEO_SITE_DATA_DIR + '/_tmp/cache/file/lock'
    }
})

#@cachemg.cache(expire=60)
def ConvertCss(filename):

    file = None
    css_type = 'css'
    css_file = filename + '.css'
    if os.path.exists( css_file ):
        file = codecs.open(css_file,"r","utf8")
    else:
        css_file = filename + '.scss'
        if os.path.exists( css_file ):
            file = codecs.open(css_file,"r","utf8")
            css_type = 'scss'

    if file :

        template = Template(    
                                file.read(),
                                lookup=TLOOKUP,
                            )
        _css = template.render(
                                paneoimg = PaneoImage,
                                PANEO_WIDTH = PANEO_WIDTH,
                                PANEO_HEIGHT = PANEO_HEIGHT,
                                TABLET_WIDTH = TABLET_WIDTH,
                                SMART_PHONE_WIDTH = SMART_PHONE_WIDTH,
        )

        if css_type == 'css':
            return _css

        if SCSS_CONV :
            _scss_vars = {}
            _scss = scss.Scss(
                scss_vars=_scss_vars,
                scss_opts={
                    'compress': False,
                    'debug_info': False,
                }
            )
            css = _scss.compile(_css)
        return css 

    return "css file not found" 

class View:
    def __init__(self):
        web.header("Content-Type", "text/css; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET(self,id="index"):
        if id == "index":
            filename = PANEO_SITE_DATA_DIR + ( '%s' % id )
        else:
            filename = PANEO_SITE_DATA_DIR + ('pages/%s' % id )

        return ConvertCss( filename )

class View_CSS:

    def __init__(self):
        web.header("Content-Type", "text/css; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET(self,id=None):
        filename = PANEO_SITE_DATA_DIR + ( 'common/css/%s' % id )
        return ConvertCss( filename )

class View_FORM:

    def __init__(self):
        web.header("Content-Type", "text/css; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET(self,id=None):
        filename = PANEO_SITE_DATA_DIR + ( 'forms/formmail_%s' % id )
        return ConvertCss( filename )
